/****** Object:  StoredProcedure [dbo].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC ]    Script Date: 06/16/2012 13:50:42 ******/
IF EXISTS (SELECT * FROM sys.objects WHERE  
				object_id = OBJECT_ID(N'[dbo].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC ]')
					   AND type IN(N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC ];
GO


--EXEC P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC 1,1,0
CREATE PROCEDURE P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_PROC @CD_EMP    INT
																  , @CD_FILIAL INT
																  , @CD_PROD INT =0
WITH ENCRYPTION
AS
BEGIN
SET NOCOUNT ON;

	DECLARE @FLAG_NOVO_MODELO_PARAMETROS INT;
	DECLARE @CD_CURVA_PD INT;

	SET @CD_CURVA_PD =(SELECT CD_CURVA_PD FROM PRC_EMP
					WHERE  CD_EMP = @CD_EMP );

	SET @FLAG_NOVO_MODELO_PARAMETROS = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE  CD_EMP = @CD_EMP AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'), 0);
		 
	IF @FLAG_NOVO_MODELO_PARAMETROS = 0 
	begin
		SET @FLAG_NOVO_MODELO_PARAMETROS = ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG 
													WHERE  
														CD_EMP = @CD_EMP 
														AND CD_FILIAL =@CD_FILIAL 
														AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'), 0);
	end

	IF @FLAG_NOVO_MODELO_PARAMETROS = 0 --Nao usa novo modelo de parametro
		BEGIN
			PRINT 'Parametro antigo '+CONVERT(VARCHAR, GETDATE(), 108);
			PRINT 'Deletando produtos '+CONVERT(VARCHAR, GETDATE(), 108);

			if @CD_PROD > 0 
			begin
				DELETE FROM EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD
				WHERE
					CD_EMP = @CD_EMP
					AND CD_FILIAL = @CD_FILIAL
					AND CD_PROD = @CD_PROD;

					
				PRINT 'Inserindo produtos '+CONVERT(VARCHAR, GETDATE(), 108);
				INSERT INTO EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD(
					CD_EMP
					, CD_FILIAL
					, CD_PROD
					, CD_SIGLA
					, VLR_PARAMETRO
					, DS_ARV_PARAM
					, FCURVA
					, FCURVA_ULT_ATU
					, DT_ULT_ALT
					, CD_ARV_PARAM
					, CD_GRUPO_CURVA
					, DT_CAD
					, CD_ARV_PARAM_MEDIAF)
				SELECT
					F.CD_EMP
					, F.CD_FILIAL
					, CD_PROD
					, L.CD_SIGLA
					, L.VLR_PARAMETRO
					, L.DS_ARV_PARAM
					, L.FCURVA
					, ISNULL(L.FCURVA_ULT_ATU,'2001-01-01') FCURVA_ULT_ATU
					, L.DT_ULT_ALT
					, L.CD_ARV_PARAM
					, L.CD_ARV_PARAM AS CD_GRUPO_CURVA
					, GETDATE()
					, 0 AS CD_ARV_PARAM_MEDIAF
				FROM
					EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL F
					INNER JOIN V_EST_ARV_MD_F_GRP_PARAM_CURVA_EST_ARV_MERC_LINHA L ON F.CD_EMP = L.CD_EMP
																					AND F.CD_ARV_PARAM = L.CD_ARV_PARAM
					INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
					L.CD_EMP = A.CD_EMP AND 
					L.CD_ARV_MERC_LINHA = A.CD_ARV_MERC_LINHA
				WHERE  F.CD_EMP = @CD_EMP
					AND F.CD_FILIAL = @CD_FILIAL
					AND A.CD_PROD =   @CD_PROD ;


				UPDATE A
				SET
					CD_ARV_PARAM_MEDIAF = C.CD_GRP_PARAM
				FROM   EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD a
					JOIN EST_PROD_EST_ARV_MERCADOLOGICA B ON A.CD_EMP = B.CD_EMP
																AND A.CD_PROD = B.CD_PROD
					JOIN V_EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL C ON A.CD_EMP = C.CD_EMP
																	AND A.CD_FILIAL = C.CD_FILIAL
																	AND A.CD_SIGLA = C.CD_SIGLA
																	AND B.CD_ARV_MERC_LINHA = C.CD_ARV_MERC_LINHA
				WHERE
					C.CD_EMP = @CD_EMP
					AND C.CD_FILIAL = @CD_FILIAL
					AND A.CD_PROD =@CD_PROD ;

			end
			else
			begin
				DELETE FROM EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD
				WHERE
					CD_EMP = @CD_EMP
					AND CD_FILIAL = @CD_FILIAL; 

				PRINT 'Inserindo produtos '+CONVERT(VARCHAR, GETDATE(), 108);
				INSERT INTO EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD(
					CD_EMP
					, CD_FILIAL
					, CD_PROD
					, CD_SIGLA
					, VLR_PARAMETRO
					, DS_ARV_PARAM
					, FCURVA
					, FCURVA_ULT_ATU
					, DT_ULT_ALT
					, CD_ARV_PARAM
					, CD_GRUPO_CURVA
					, DT_CAD
					, CD_ARV_PARAM_MEDIAF)
				SELECT
					F.CD_EMP
					, F.CD_FILIAL
					, CD_PROD
					, L.CD_SIGLA
					, L.VLR_PARAMETRO
					, L.DS_ARV_PARAM
					, L.FCURVA
					, ISNULL(L.FCURVA_ULT_ATU,'2001-01-01') FCURVA_ULT_ATU
					, L.DT_ULT_ALT
					, L.CD_ARV_PARAM
					, L.CD_ARV_PARAM AS CD_GRUPO_CURVA
					, GETDATE()
					, 0 AS CD_ARV_PARAM_MEDIAF
				FROM
					EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL F
					INNER JOIN V_EST_ARV_MD_F_GRP_PARAM_CURVA_EST_ARV_MERC_LINHA L ON F.CD_EMP = L.CD_EMP
																					AND F.CD_ARV_PARAM = L.CD_ARV_PARAM
					INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
					L.CD_EMP = A.CD_EMP AND 
					L.CD_ARV_MERC_LINHA = A.CD_ARV_MERC_LINHA
				WHERE  F.CD_EMP = @CD_EMP
					AND F.CD_FILIAL = @CD_FILIAL  ;


				UPDATE A
				SET
					CD_ARV_PARAM_MEDIAF = C.CD_GRP_PARAM
				FROM   EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD a
					JOIN EST_PROD_EST_ARV_MERCADOLOGICA B ON A.CD_EMP = B.CD_EMP
																AND A.CD_PROD = B.CD_PROD
					JOIN V_EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL C ON A.CD_EMP = C.CD_EMP
																	AND A.CD_FILIAL = C.CD_FILIAL
																	AND A.CD_SIGLA = C.CD_SIGLA
																	AND B.CD_ARV_MERC_LINHA = C.CD_ARV_MERC_LINHA
				WHERE
					C.CD_EMP = @CD_EMP
					AND C.CD_FILIAL = @CD_FILIAL;
			end
		END;

/*****************************************************************************************************************************************************************************/
--Usa novo modelo de parametro
/*****************************************************************************************************************************************************************************/

	IF @FLAG_NOVO_MODELO_PARAMETROS = 1 --Usa novo modelo de parametro
		BEGIN
		
			CREATE TABLE #RsProdProcPareto
						(CD_EMP              INT
						, CD_FILIAL           INT
						, CD_CTR              INT
						, CD_PROD             INT
						, CD_SIGLA            INT
						, VLR_PARAMETRO       MONEY
						, DS_ARV_PARAM        VARCHAR(250)
						, FCURVA              INT
						, FCURVA_ULT_ATU      DATETIME
						, DT_ULT_ALT          DATETIME
						, CD_ARV_PARAM        INT
						, CD_GRUPO_CURVA      INT
						, CD_ARV_PARAM_MEDIAF INT
						);

			PRINT 'Parametro novo '+CONVERT(VARCHAR, GETDATE(), 108);
			PRINT 'Inserindo produtos '+CONVERT(VARCHAR, GETDATE(), 108);

			IF @CD_PROD > 0
			BEGIN
				INSERT INTO #RsProdProcPareto(
					CD_EMP
					, CD_FILIAL
					, CD_CTR
					, CD_PROD
					, CD_SIGLA
					, VLR_PARAMETRO
					, DS_ARV_PARAM
					, FCURVA
					, FCURVA_ULT_ATU
					, DT_ULT_ALT
					, CD_ARV_PARAM
					, CD_GRUPO_CURVA
					, CD_ARV_PARAM_MEDIAF)
				SELECT
					EST_PROD_CPL.CD_EMP
					, EST_PROD_CPL.CD_FILIAL
					, EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_CTR
					, EST_PROD_CPL.CD_PROD
					, 1 CD_SIGLA
					, 0 AS VLR_PARAMETRO
					, 'GRUPO DE CURVA NAO DEFINIDO' AS DS_ARV_PARAM
					, 0 AS FCURVA
					, CONVERT(CHAR(10), GETDATE() - 1, 112) AS FCURVA_ULT_ATU
					, NULL AS DT_ULT_ALT
					, -1 AS CD_ARV_PARAM
					, -1 AS CD_GRUPO_CURVA
					, EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_CTR
				FROM
					EST_PROD_CPL
					INNER JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL ON 
					EST_PROD_CPL.CD_EMP = EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_EMP AND 
					EST_PROD_CPL.CD_FILIAL = EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_FILIAL 
				WHERE  
				EST_PROD_CPL.CD_EMP = @CD_EMP
				AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
				AND EST_PROD_CPL.TP_PROD =0
				AND EST_PROD_CPL.CD_PROD = CASE WHEN @CD_PROD=0 THEN EST_PROD_CPL.CD_PROD ELSE @CD_PROD END ;
			END
			ELSE
			BEGIN
				INSERT INTO #RsProdProcPareto(CD_EMP, CD_FILIAL, CD_CTR, CD_PROD, CD_SIGLA, VLR_PARAMETRO, DS_ARV_PARAM, FCURVA
												, FCURVA_ULT_ATU, DT_ULT_ALT, CD_ARV_PARAM, CD_GRUPO_CURVA, CD_ARV_PARAM_MEDIAF)
					SELECT
						EST_PROD_CPL.CD_EMP
						, EST_PROD_CPL.CD_FILIAL
						, EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_CTR
						, EST_PROD_CPL.CD_PROD
						, 1 CD_SIGLA
						, 0 AS VLR_PARAMETRO
						, 'GRUPO DE CURVA NAO DEFINIDO' AS DS_ARV_PARAM
						, 0 AS FCURVA
						, CONVERT(CHAR(10), GETDATE() - 1, 112) AS FCURVA_ULT_ATU
						, NULL AS DT_ULT_ALT
						, -1 AS CD_ARV_PARAM
						, -1 AS CD_GRUPO_CURVA
						, EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_CTR
					FROM
						EST_PROD_CPL
						INNER JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL ON 
						EST_PROD_CPL.CD_EMP = EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_EMP AND 
						EST_PROD_CPL.CD_FILIAL = EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_FILIAL 
					WHERE  
					EST_PROD_CPL.CD_EMP = @CD_EMP
					AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
					AND EST_PROD_CPL.TP_PROD =0				
			END
		--------------------------------------------------------------------------------------------------------------------------

		DELETE FROM T
		FROM 
			#RsProdProcPareto T
			JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD P ON 
			T.CD_EMP	= P.CD_EMP AND 
			T.CD_PROD	= P.CD_PROD  AND 
			T.CD_FILIAL = P.CD_FILIAL; 



		INSERT INTO EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD(CD_EMP, CD_FILIAL, CD_PROD
																	, CD_SIGLA, VLR_PARAMETRO, DS_ARV_PARAM, FCURVA, FCURVA_ULT_ATU
																	, DT_ULT_ALT, CD_ARV_PARAM, CD_GRUPO_CURVA, DT_CAD, CD_ARV_PARAM_MEDIAF)
		SELECT
			L.CD_EMP
			, L.CD_FILIAL
			, L.CD_PROD
			, L.CD_SIGLA
			, L.VLR_PARAMETRO
			, L.DS_ARV_PARAM
			, L.FCURVA
			, ISNULL(L.FCURVA_ULT_ATU,'2001-01-01') FCURVA_ULT_ATU
			, NULL AS DT_ULT_ALT
			, L.CD_ARV_PARAM
			, L.CD_ARV_PARAM AS CD_GRUPO_CURVA
			, GETDATE()
			, L.CD_ARV_PARAM_MEDIAF
		FROM
			#RsProdProcPareto L
			LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD p ON l.CD_EMP = p.CD_EMP
							AND l.CD_FILIAL = p.CD_FILIAL
							AND l.CD_PROD = p.CD_PROD 
		WHERE
			P.CD_EMP IS NULL;

		--------------------------------------------------------------------------------------------------------------------------------

		Print 'Processando grupo de parametros  '+CONVERT(VARCHAR, GETDATE(), 108);
		EXEC P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_EST_PARAM_COMPRAS_GRUPO_CURVA @CD_EMP, @CD_FILIAL, @CD_PROD;

		--------------------------------------------------------------------------------------------------------------------------------

				 
	END;

	--------------------------------------------------------------------------------------------------------------------------------
	PRINT 'Fim processo'+CONVERT(VARCHAR, GETDATE(), 108);

END;